<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Popup.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new Popup($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new Popup($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setLink(filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING));
            $occorrenza->setSecondi(filter_input(INPUT_POST,"secondi",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->crea();
            header("Location: ../creaPopup.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->caricaDatiDalDatabase();
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setLink(filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING));
            $occorrenza->setSecondi(filter_input(INPUT_POST,"secondi",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->modifica();
            header("Location: ../creaPopup.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'modificaImmagine':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/popup", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $occorrenza->cambiaImmagine($percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'eliminaImmagineOccorrenza':
            $occorrenza->cambiaImmagine('');
            echo "ok";
            break;
        case 'modificaImmagineOccorrenzaConPercorso':
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $occorrenza->cambiaImmagine($percorso);
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaPopup.php?id={$idNuovaForm}&status=260");
            break;
    }
